<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;
use Illuminate\Support\Facades\Artisan;

class UpdateFranchisesFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'franchises',
            fieldName: 'introduction',
            options:             [
                'name' => 'introduction',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Introduction',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -4
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'franchises',
            fieldName: 'banner',
            options:         [
                'name' => 'banner',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Bannière',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ],
            ],
            weight: -4
        );

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: "franchises_documents",
            fieldName: 'document'
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'franchises_documents',
            fieldName: 'file',
            options:         [
                'name' => 'file',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Fichier',
                ],
                'widget' => [
                    'type' => BridgeContentType::FILE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::FILE_FIELD,
                'settings' => [
                    'display_field' => false,
                    'display_default' => false,
                    'uri_scheme' => 'public',
                    'target_type' => 'file',
                    'cardinality' => 1,
                ],
            ],
            weight: -4
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'franchises',
            fieldName: 'brands',
            options:         [
                'name' => 'brands',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 0,
                'title' => [
                    'fr' => 'Marque',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['brands'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: -3
        );

        Artisan::call("models:rebuild");
    }
}
