<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class AddFieldWeightOnHubBlockLinks extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        if (Schema::hasFields('hub_block_links', ['weight'])) {
            return;
        }

        $bridge->contentTypeCreateOrUpdateField(
            type: 'hub_block_links',
            fieldName: 'weight',
            options: [
                'name' => 'weight',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Ordre d\'affichage',
                ],
                'description' => [
                    'fr' => 'Le chiffre le plus bas remonte en 1er',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => 0,
            ],
            weight: 0
        );
    }
}
