<?php

use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\Users;
use Illuminate\Support\Arr;

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'firstname' => 'givenName',
        'lastname' => 'surname',
        'function' => 'jobTitle',
        'phone' => fn (mixed $user) => Arr::first($user->businessPhones) ?? " ",
        'mobile_phone' => 'mobilePhone',
        'structure_profiles' => fn (mixed $user) =>  reference('structure_profiles')
            ->identifiedBy('code')
            ->from(strtoupper(trim($user->onPremisesExtensionAttributes->extensionAttribute2)))
            ->get(),
        'animators' => fn (mixed $user) =>  reference('animators')
            ->identifiedBy('code')
            ->from(strtoupper(trim($user->onPremisesExtensionAttributes->extensionAttribute3)))
            ->get(),
        'companies' => function (mixed $user) {
            $attr11 = $user->onPremisesExtensionAttributes->extensionAttribute11;
            $containSupports = collect(explode(',', $attr11))
                ->map(fn ($brand) => strtolower(trim($brand)))
                ->contains('support');

            if ($containSupports) {
                return type_to_class('companies')::query()
                    ->where('status', '1')
                    ->get()
                    ->pluck('uuid')
                    ->toArray();
            }

            return collect(explode(',', $user->onPremisesExtensionAttributes->extensionAttribute1))
                ->map(
                    fn($company) => reference('companies')
                        ->identifiedBy('company_id')
                        ->from(ucfirst(trim($company)))
                        ->withoutCreation()
                        ->first()
                )
                ->filter()
                ->values()
                ->toArray();
        },
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from(ucfirst(trim($user->city)))
            ->get(),
        'teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'users' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from($user->manager)
            ->withoutCreation()
            ->first(),
        'brands' => function (mixed $user) {
            $attr11 = $user->onPremisesExtensionAttributes->extensionAttribute11;
            $containSupports = collect(explode(',', $attr11))
                ->map(fn ($brand) => strtolower(trim($brand)))
                ->contains('support');

            if ($containSupports) {
                return type_to_class('brands')::query()
                    ->where('status', '1')
                    ->get()
                    ->pluck('uuid')->toArray();
            }

            $brands = collect(range(5, 13))
                ->flatMap(function ($i) use ($user) {
                    $attributeName = "extensionAttribute{$i}";
                    if (!isset($user->onPremisesExtensionAttributes->$attributeName)) {
                        return [];
                    }
                    return explode(',', $user->onPremisesExtensionAttributes->$attributeName);
                })
            ->map(
                fn ($brand) => reference('brands')
                    ->identifiedBy('code')
                    ->from(strtoupper(trim($brand)))
                    ->first()
            )
                ->filter()
                ->values()
                ->toArray();
            return $brands;
        }
    ],
];
