import RhSpacePage from '../pages/spaces/RhSpacePage'
import RhPage from '../pages/spaces/RhPage'

import TabSpacePage from '../pages/tab-spaces/TabSpacePage'

import { withFetch } from 'inside-collection/hocs'

import { fetchRhSpacePage, fetchRhPage } from '../components/spaces/fetch'
import { fetchTabSpacesPage } from '../components/tab-spaces/fetch'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false },
    props: { commentsEnabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false },
    props: {
      useRelatedSlot: false,
      commentsEnabled: false
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/jobs/JobsListingPage')
  },
  {
    name: 'TeamsListingPage',
    component: () => import('@inside-teams/components/pages/TeamsListingPage')
  },
  {
    path: '/espace/:slug',
    name: 'RhSpacePage',
    component: withFetch(RhSpacePage, { size: 'xxl' })(fetchRhSpacePage)
  },
  {
    path: '/espace/:slug/pages',
    name: 'RhPage',
    component: withFetch(RhPage, { size: 'xxl' })(fetchRhPage)
  },
  {
    name: 'MapPage',
    component: () => import('@inside-maps/components/pages/MapPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'TabSpacePage',
    path: '/espaces/:slug',
    component: withFetch(TabSpacePage, { size: 'xxl', watch: true })(
      fetchTabSpacesPage
    )
  }
]
