import { http } from '@inside-library/helpers/Http'

export default {
  jobsSpaces: {
    add: ({ data }) => ({
      name: 'RhSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  jobsPages: {
    fields: ['uuid', { jobs_grouping_pages: [{ jobs_spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'RhPage',
      params: {
        slug: data.jobs_grouping_pages.data[0].jobs_spaces.data[0].slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'RhSpacePage',
      params: {
        slug: data.jobs_grouping_pages.data[0].jobs_spaces.data[0].slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: jobsGroupingPages } = await http.get('content/jobs_pages', {
        fields: ['uuid', { jobs_grouping_pages: ['uuid', 'title'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      const { data: jobsSpace } = await http.get(
        'content/jobs_grouping_pages',
        {
          fields: ['uuid', { jobs_spaces: ['uuid', 'title', 'slug'] }],
          filters: {
            'uuid:eq': jobsGroupingPages[0]?.jobs_grouping_pages?.data[0]?.uuid
          }
        }
      )

      const slug = jobsSpace[0]?.jobs_spaces?.data[0]?.slug[0]

      return {
        route: {
          name: 'RhPage',
          params: { slug },
          query: { page: data.uuid }
        }
      }
    }
  },
  jobsGroupingPages: {
    fields: [{ jobs_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'RhSpacePage',
      params: { slug: data.jobs_spaces.data[0].slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'RhSpacePage',
      params: { slug: data.jobs_spaces.data[0].slug[0] }
    })
  },
  tabSpaces: {
    add: ({ data }) => ({
      name: 'TabSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  tabs: {
    add: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          fields: [
            {
              tab_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'TabSpacePage',
          params: { slug: tab?.[0]?.tab_spaces?.slug[0] }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          fields: [
            {
              tab_spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'TabSpacePage',
          params: { slug: tab?.[0]?.tab_spaces?.slug[0] }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  subTabPages: {
    add: async ({ data }) => {
      try {
        const { data: subPage } = await http.get('content/sub_tab_pages', {
          fields: [
            'uuid',
            {
              tabs: [
                'uuid',
                'title',
                {
                  tab_spaces: ['uuid', 'title', 'slug']
                }
              ]
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'TabSpacePage',
          params: { slug: subPage?.[0]?.tabs?.tab_spaces?.slug[0] },
          query: { page: data.uuid }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: subPage } = await http.get('content/sub_tab_pages', {
          fields: [
            'uuid',
            {
              tabs: [
                'uuid',
                'title',
                {
                  tab_spaces: ['uuid', 'title', 'slug']
                }
              ]
            }
          ],
          filters: { 'uuid:eq': data.uuid }
        })

        return {
          name: 'TabSpacePage',
          params: { slug: subPage?.[0]?.tabs?.tab_spaces?.slug[0] }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: () => ({ routeAs: 'add' })
  },
  jobsOffers: {
    globalSearch: ({ data, vm }) => ({
      action: () =>
        vm.triggerModal(
          'job-offer',
          'fetch',
          {
            item: data
          },
          { layout: 'right', size: 'm', transition: 'fadeInLeft' }
        )
    })
  }
}
