import { markRaw } from 'vue'
import { IconText } from 'inside-collection/atoms'

export default {
  'inside-news': {
    bookmarkEnabled: false,
    dateEnabled: {
      fullPage: true,
      listingComponent: false
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true
    },
    shortcuts: {
      max: 5
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'uuid',
          'image',
          'firstname',
          'lastname',
          'phone',
          { functions: ['title'] }
        ]
      }
    }
  },
  'inside-jobs': {
    modalName: 'job-offer',
    extraFields: ['directions', 'locations'],
    cardOverrides: (data, { addItemAfter }) => {
      addItemAfter('contract', {
        id: 'location',
        tag: markRaw(IconText),
        data: { icon: 'address' },
        value: data?.locations?.title
      })
      addItemAfter('location', {
        id: 'direction',
        tag: markRaw(IconText),
        data: { icon: 'user-id' },
        value: data?.directions?.title
      })
    }
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'functions',
        class: 'function',
        data: data => data.functions?.title
      }
    ]
  }
}
