export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'email',
      'phone',
      'mobile_phone',
      'image',
      { functions: ['uuid', 'title'] },
      'linkedin',
      'twitter',
      { locations: ['uuid', 'title'] },
      {
        users: [
          'uuid',
          'firstname',
          'lastname',
          { functions: ['uuid', 'title'] },
          'image',
          'phone'
        ]
      },
      {
        'users.users': {
          fields: [
            'uuid',
            'firstname',
            'lastname',
            { functions: ['uuid', 'title'] },
            'image',
            'phone'
          ],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            alias: 'coworkers'
          }
        }
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  jobs_offers: {
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'link',
      'button_link',
      'content',
      { contracts_types: ['uuid', 'title'] },
      { directions: ['uuid', 'title'] },
      { locations: ['uuid', 'title'] }
    ]
  },
  markers: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'slug',
      'image',
      'reception_hours',
      'activities_hours',
      'phone',
      'address',
      'how_to_access',
      'practical_information',
      { activities: ['uuid', 'title', 'slug'] },
      { referents: ['uuid', 'firstname', 'lastname', 'image'] }
    ]
  },
  groups_documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      { authors: ['lastname', 'firstname'] },
      'content',
      'body',
      'content_type',
      'created_at',
      'file',
      'langcode',
      'pid',
      'status',
      'title',
      'updated_at',
      'uuid',
      'uuid_host',
      { reactions: ['count', { users: ['uuid'] }] },
      { groups_folders: ['title'] }
    ]
  }
}
