import { http } from '@inside-library/helpers/Http'

const fetchRhSpacePage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/jobs_spaces', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'description',
        'image',
        'admin',
        'short_content',
        {
          key_contacts: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              { functions: ['uuid', 'title'] },
              'phone'
            ],
            filters: { sort: 'lastname:asc' }
          }
        },
        {
          documents: [
            'uuid',
            'title',
            'file',
            'has_section',
            'admin',
            'content_type'
          ]
        },
        {
          jobs_grouping_pages: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

const fetchRhPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/jobs_spaces', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'image',
        'slug',
        'description'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchRhSpacePage, fetchRhPage }
