<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddTabsIconColorField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        if (Schema::hasModel('tabs')) {
            $this->getBridge()?->contentTypeCreateOrUpdateField(
                type: 'tabs',
                fieldName: 'icon_color',
                options: [
                    'name' => 'icon_color',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 4,
                    'title' => [
                        'fr' => "Couleur de l'icône",
                    ],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                        'settings' => [],
                        'weight' => 4,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
                weight: 4
            );
        }

        $this->finishUp();
    }
}
