<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RemoveContentTypesFromGlobalSearch extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = [
            'users',
            'tab_spaces',
        ];

        foreach ($contentTypes as $type) {
            $bridge->updateContentTypeOptions($type, ['global_searchable' => false]);
        }
    }
}
