<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class updatePermissibleContents extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->updateContentTypeOptions('jobs_spaces', ['permissible' => true, 'categorizable' => true]);
        $this->getBridge()?->updateContentTypeOptions('jobs_grouping_pages', ['permissible' => true]);
        $this->finishUp();
    }
}
