<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MarkersSchedulesToWysiwyg extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'marker',
            'schedules',
            [
                'name' => 'schedules',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Horaires',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        );
    }
}
