<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

final class ApasMakeFunctionSearchable extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->updateContentTypeOptions('functions', ['searchable' => true]);
        Artisan::call('index:rebuild', ['--type' => 'functions']);
        Artisan::call('index:rebuild', ['--type' => 'users']);
        $this->finishUp();
    }
}
