<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class MakeFunctionSearchableForUser extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateOrUpdateField('users', 'functions', [
            'name' => 'functions',
            'searchable_filter' => true,
        ]);

        $this->finishUp();
    }
}
