<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Functions;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class CreateFunctionsContentType extends Migration
{
    use Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        // Creating the functions content type
        $this->migrateContent('functions');
        $this->finishUp();

        $contentTypeBridge = new BridgeContentType();

        // adding a field functions to the content type users refering to the above functions created content type
        $contentTypeBridge->contentTypeCreateOrUpdateField(
            'users',
            'functions',
            [
                'name' => 'functions',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Fonctions',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['functions'],
                    'cardinality' => 1,
                ],
                'selectable_all' => false,
            ]
        );

        // adding the functions to users

        $contentBridge = new BridgeContent();

        Users::select('function', 'uuid')->get()->each(function ($user) use ($contentBridge) {
            if (! $user->function) {
                return;
            }

            $uuid = Functions::where('title', $user->function)->first()?->uuid;

            if (! $uuid) {
                $uuid = $contentBridge->contentInsert('functions', [
                    'title' => $user->function,
                ]);
            }

            $contentBridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'functions' => $uuid,
            ]);
        });

        // deleting field function from users
        $contentTypeBridge->contentTypeDeleteField('node', 'users', 'function');
    }
}
