<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Departments;
use Inside\Content\Models\Contents\Locations;
use Inside\Host\Bridge\BridgeContent;

final class RemoveUnusedDepartmentsAndLocations extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        Departments::query()
            ->whereDoesntHave('reverseUsers')
            ->whereDoesntHave('reverseJobsOffers')
            ->pluck('uuid')
            ->each(fn (string $uuid) => $bridge->contentDelete('departments', $uuid));

        Locations::query()
            ->whereDoesntHave('reverseUsers')
            ->whereDoesntHave('reverseJobsOffers')
            ->pluck('uuid')
            ->each(fn (string $uuid) => $bridge->contentDelete('locations', $uuid));
    }
}
