<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateSearchableContentTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = [
            'contracts_types' => 'Type de contrat',
            'departments' => 'Direction',
            'locations' => 'Localisation',
        ];

        foreach ($contentTypes as $type => $title) {
            $bridge->contentTypeUpdateOrCreate($type, [
                'searchable' => true,
                'listing_type' => 'content',
                'title' => [
                    'fr' => $title,
                ],
            ]);
        }
    }
}
