import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  pagesCategories: {
    fields: ['uuid', { spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] },
      query: { tab: data.uuid }
    }),
    delete: ({ data }) => {
      return {
        name: 'SpacePage',
        params: {
          slug: data.spaces.slug[0]
        }
      }
    }
  },
  spacesPages: {
    fields: [{ pages_categories: ['uuid', { spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { tab: data.pages_categories.uuid }
    }),
    delete: ({ data }) => {
      return {
        name: 'SpacePage',
        params: {
          slug: data.pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const uuid = data.uuid

      try {
        const { data: pages } = await http.get('content/spaces_pages', {
          filters: {
            'uuid:eq': uuid
          },
          fields: ['slug', { pagesCategories: { fields: ['uuid', 'slug'] } }]
        })

        const { data: slug } = await http.get('content/pages_categories', {
          filters: {
            'uuid:eq': pages[0].pagesCategories[0].uuid
          },
          fields: ['slug', { spaces: { fields: ['uuid', 'slug'] } }]
        })

        return {
          route: {
            name: 'SpacesPagesListingPage',
            params: {
              slug: slug[0].spaces.slug[0]
            },
            query: { page: uuid }
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  residencies: {
    add: () => ({
      name: 'MapPage'
    }),
    delete: () => ({
      name: 'MapPage'
    }),
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  residenciesTypes: {
    add: () => ({
      name: 'MapPage'
    }),
    delete: () => ({
      name: 'MapPage'
    })
  }
}
