import { withFetch } from 'inside-collection/hocs'

import SpacesListingPage from '../pages/spaces/SpacesListingPage'
import SpacePage from '../pages/spaces/SpacePage'
import SpacesPagesListingPage from '../pages/spaces/SpacesPagesListingPage'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

import {
  fetchSpace,
  fetchSpacesPagesListing,
  fetchSpacesListing
} from '../fetch/spaces'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    component: () => import('../pages/NewsListingPage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    meta: { disabled: false },
    component: () => import('../pages/MapPage')
  },
  {
    name: 'EventPage',
    meta: { disabled: false, content: 'events' }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminMailingsListPage',
    meta: { inSidebar: true }
  },
  {
    name: 'AdminMailingsPreviewPage',
    meta: { inSidebar: true }
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces',
    component: withFetch(SpacesListingPage)(fetchSpacesListing)
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage)(fetchSpace)
  },
  {
    name: 'SpacesPagesListingPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesListingPage)(fetchSpacesPagesListing)
  }
]
