export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'function',
      'email',
      'phone',
      'mobile_phone',
      'link_twitter',
      'link_linkedin',
      { services: ['uuid', 'title'] },
      { residencies: ['uuid', 'title'] },
      { territorial_groupings: ['uuid', 'title'] }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  residencies: {
    modalFields: [
      'uuid',
      'title',
      'image',
      'content',
      'address',
      'zip_code',
      'city',
      { residencies_types: ['title', 'uuid'] },
      { territorial_groupings: ['title', 'uuid'] },
      {
        users: {
          fields: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            'function',
            'mobile_phone'
          ],
          filters: { reverse: true, 'status:eq': 1 }
        }
      }
    ]
  }
}
