<?php

namespace Inside\ALJT\Providers;

use Inside\ALJT\Console\ContentsCsvImportCommand;
use Inside\ALJT\Contracts\ContentsCsvImporter as ContentsCsvImporterContract;
use Inside\ALJT\Services\ContentsCsvImporter;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

class ServiceProvider extends BaseServiceProvider
{
    public array $bindings = [
        ContentsCsvImporterContract::class => ContentsCsvImporter::class,
    ];

    protected array $commands = [
        ContentsCsvImportCommand::class,
    ];

    public function register(): void
    {
        $this->mergeConfigTo(__DIR__.'/../../config/contents_import.php', 'contents_import');
        $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
        $this->mergeConfigTo(__DIR__ . '/../../config/import.php', 'import');
        $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
    }
}
