<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Host\Bridge\BridgeContentType;

class UpdateTerritorialGroupingsCardinality extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField('territorial_groupings', 'code', [
            'name' => 'code',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'title' => [
                'fr' => 'Code',
            ],
            'description' => [
                'fr' => 'Identifiant de la résidence',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);
        $bridgeContentType->switchCardinalityFromUnaryToMultiple('users', 'territorial_groupings');
        $bridgeContentType->contentTypeUpdateField('users', 'territorial_groupings', [
            'name' => 'territorial_groupings',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Groupement territorial',
            ],
            'description' => [
                'fr' => 'Choix du groupement territorial',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['territorial_groupings'],
                'cardinality' => -1,
            ],
        ]);
        $this->finishUp();
    }
}
