<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateTerritorialGroupingsLabel extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdate('territorial_groupings', [
            'title' => [
                'fr' => 'Territoire',
            ],
        ]);
        foreach (['users', 'residencies'] as $type) {
            $this->getBridge()?->contentTypeCreateOrUpdateField($type, 'territorial_groupings', [
                'title' => [
                    'fr' => 'Territoire',
                ],
                'description' => [
                    'fr' => 'Choix du territoire',
                ],
            ]);
        }
        $this->finishUp();
    }
}
