<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => '',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/aljt-back/resources/assets/img/logo-intranet.png',
        'logoWidth' => 170,
    ],
    'banner' => [
        'backgroundColor' => '#FFFFFF',
        'bannerWidth' => 700,
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_intro',
        'textColor' => '#2C3E50',
    ],
    'sections' => [
        'news' => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'sectionType' => 'news',
            'types' => ['news'],
            'fieldLabel' => [
                'news' => [
                    'fr' => 'Actualités à la une',
                ],
            ],
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#B1D331',
            'link' => [
                'sectionLinkUrl' => 'actualites',
                'sectionArrowUrl' => 'vendor/maecia/aljt-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#B1D331',
                'sectionLinkStrKey' => 'newsletter.news_link',
            ],
        ],
        'events' => [
            'sectionTitleStrKey' => 'Agenda - Dates à retenir',
            'types' => ['events'],
            'fieldLabel' => [
                'events' => [
                    'fr' => 'Événements',
                ],
            ],
            'sorts' => ['date:desc'],
            'link' => [
                'sectionLinkUrl' => 'evenements',
                'sectionArrowUrl' => 'vendor/maecia/aljt-back/resources/assets/img/newsletter/arrow.png',
                'sectionTextColor' => '#B1D331',
                'sectionLinkStrKey' => 'Voir toutes les dates',
            ],
        ],
        'activities' => [
            'sectionTitleStrKey' => 'Activités en chiffres',
            'link' => null, // Pas de links
            'orientation' => 'horizontal',
            'defaultBackgroundColor' => '#FFFFF',
            'defaultValueColor' => '#2C3E50',
            'items' => [
                'comments' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Comments::count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/aljt-back/resources/assets/img/newsletter/comments.png',
                    'titleStrKey' => 'newsletter.comments_statistic',
                ],
                'likes' => [
                    'callback' => function () {
                        return \Inside\Reaction\Models\Reaction::where(
                            'type',
                            'like'
                        )->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/aljt-back/resources/assets/img/newsletter/likes.png',
                    'titleStrKey' => 'newsletter.likes_statistic',
                ],
                'users' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\Users::where(
                            'status',
                            true
                        )->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/aljt-back/resources/assets/img/newsletter/users.png',
                    'titleStrKey' => 'newsletter.users_statistic',
                ],
                'news' => [
                    'callback' => function () {
                        return \Inside\Content\Models\Contents\News::where(
                            'status',
                            true
                        )->count();
                    },
                    'backgroundImageUrl' => 'vendor/maecia/aljt-back/resources/assets/img/newsletter/news.png',
                    'titleStrKey' => 'newsletter.contents_statistic',
                ],
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#B1D331',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/association.aljt',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/aljtweet',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/aljt',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/user/AnimateurALJT',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/aljtasso/',
            ],
            'viadeo' => [
                'imageUrl' => url('vendor/maecia/aljt-back/resources/assets/img/newsletter/viadeo.png'),
                'url' => 'https://www.viadeo.com/fr/company/aljt',
                'titleStrKey' => 'Viadeo',
            ],
        ],
    ],
    'footer' => [
        'backgroundColor' => '#F0F0F0',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning',
    ],
];
