import { withFetch } from 'inside-collection/hocs'

import { fetchSpacesListing } from '../fetch'
import TabsSpacesListingPage from '../pages/spaces/TabsSpacesListingPage'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/home/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: {
      component: 'minimal'
    }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'NewcomersListingPage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/users/DirectoryPage')
  },
  {
    name: 'TabsSpacesListingPage',
    path: '/espaces/:slug',
    component: withFetch(TabsSpacesListingPage)(fetchSpacesListing)
  },
  {
    name: 'TabsSpacePage',
    props: {
      bannerData: {
        add: ['tabs', 'tabs_pages']
      }
    },
    path: '/espaces/:slug/page',
    meta: { disabled: false }
  }
]
