export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-commons': {
    banner: {
      darkMode: false
    }
  },
  'inside-events': {
    calendarImportEnabled: true,
    subscriptionEnabled: true
  },
  'inside-users': {
    allowAvatarEdition: false,
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: null }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        requestFields: [
          'firstname',
          'lastname',
          'image',
          { functions: ['title'] }
        ]
      }
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  }
}
