import { http } from '@inside-library/helpers/Http'

const fetchSpacesListing = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tabs_spaces_categories', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        {
          tabs_spaces: {
            fields: [
              'uuid',
              'title',
              'thumbnail_image',
              'admin',
              'content_type',
              'slug'
            ],
            filters: {
              reverse: true,
              'status:eq': true,
              sort: 'weight:asc'
            }
          }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSpacesListing }
