<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'name' => 'Newsletter',
        'fieldsPrefix' => 'nl_',
    ],
    'logo' => [
        'showLogo' => true,
        'logoUrl' => 'vendor/maecia/alfa-back/resources/assets/img/logo.png',
        'logoWidth' => 170,
    ],
    'banner' => [
        'backgroundImageUrl' => 'vendor/maecia/alfa-back/resources/assets/img/newsletters/banner.jpeg',
        'backgroundColor' => '#ffff',
    ],
    'introduction' => [
        'introductionFieldName' => 'nl_introduction',
    ],
    'sections' => [
        'news' => [
            'types' => ['news'],
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#DE630A',
            'dateFieldName' => 'updated_at',
            'link' => [
                'sectionLinkUrl' => 'news',
                'sectionTextColor' => '#DE630A',
            ],
        ],
        'events' => [
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#DE630A',
            'link' => [
                'sectionLinkUrl' => 'events',
                'sectionTextColor' => '#DE630A',
            ],
        ],
        'documents' => [
            'types' => ['documents'],
            'parentFieldName' => 'folders',
            'leftLineColor' => '#DE630A',
            'link' => [
                'sectionLinkUrl' => 'ged',
                'sectionTextColor' => '#DE630A',
            ],
        ],
        'new_members' => [
            'types' => ['movements'],
            'leftLineColor' => '#DE630A',
            'link' => [
                'sectionLinkUrl' => 'movements',
                'sectionTextColor' => '#DE630A',
            ],
        ],
    ],
    'socials' => [
        'backgroundColor' => '#DE630A',
        'links' => [
            'facebook' => [
                'url' => 'https://www.facebook.com/alfa3aaa/?locale=fr_FR',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/Alfa3a_Asso',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/alfa3a/?originalSubdomain=fr',
            ],
            'youtube' => [
                'url' => 'https://www.youtube.com/channel/UCbkpRBI0ASuj6Miuz7EZI1A',
            ],
        ],
    ],
];
