<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class SeedAzureGroups extends Migration
{
    public function up(): void
    {
        /** @var Inside\Database\Eloquent\Builder  $query */
        $query = type_to_class('azure_groups')::query();
        $groups = config('azuread.internal_groups');
        $bridge = new BridgeContent();

        foreach ($groups as $uuid => $name) {
            if ($query->where('external_id', $uuid)->doesntExist()) {
                $bridge->contentInsert('azure_groups', [
                    'title' => $name,
                    'external_id' => $uuid,
                ], true, true);
            }
        }
    }
}
