<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;

class AddCodeFieldToUserReferences extends Migration
{
    protected array $contentTypes = ['functions', 'departments', 'buildings', 'cities'];

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        collect($this->contentTypes)->each(
            fn ($contentType) => $bridgeContentType->contentTypeCreateOrUpdateField(
                type: $contentType,
                fieldName: 'code',
                options: [
                    'name' => 'code',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 1,
                    'title' => [
                        'fr' => 'Référence d\'import',
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ]
                ],
                weight: 1
            )
        );

        $bridgeContent = new BridgeContent();
        collect($this->contentTypes)->each(
            function ($contentType) use ($bridgeContent) {
                type_to_class($contentType)::all()->each(
                    fn ($content) =>
                    $bridgeContent->contentUpdate($contentType, [
                        'uuid' => $content->uuid,
                        'code' => $content->title,
                    ])
                );
            }
        );
    }
}
