<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\AzureGroups;
use Inside\Host\Bridge\BridgeContent;

final class UpdateAzureGroupsContents extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $groups = collect([
            '5af23957-ac0f-4c46-a72b-f8557fc60608' => 'App_EXTRANET_Assistantes',
            '6d093447-a999-4cf3-92c6-2980e0a3c3fb' => 'App_EXTRANET_Contributeurs',
        ]);

        $bridge = new BridgeContent();
        $groups->each(function (string $title, string $externalId) use ($bridge) {
            $data = [
                'title' => $title,
                'external_id' => $externalId,
            ];

            $existing = AzureGroups::where('external_id', $externalId)->first()?->uuid;

            if ($existing !== null) {
                $data['uuid'] = $existing;
                return $bridge->contentUpdate('azure_groups', $data, true);
            }

            return $bridge->contentInsert('azure_groups', $data, true, true);
        });
    }
}
