<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;
use Inside\Content\Seeders\DefaultCustomsSeeder;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class SeedCustoms extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        Artisan::call('db:seed', ['--class' => DefaultCustomsSeeder::class, '--force' => true]);

        $customs = collect([
            [
                'custom_slug' => 'faq',
                'redirection_page' => 'FAQListingPage',
                'title' => 'FAQ',
            ],
        ]);

        $bridge = new BridgeContent();

        $customs->each(function (array $custom) use ($bridge) {
            $existing = Custom::where('redirection_page', $custom['redirection_page'])->first();

            if ($existing instanceof Custom) {
                $custom['uuid'] = $existing->uuid;
                return $bridge->contentUpdate('custom', $custom, true);
            }

            return $bridge->contentInsert('custom', $custom, true, true);
        });
    }
}
