<?php

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Inside\Host\Bridge\BridgeContent;

return [
    'postfilter' => function (Collection $users): Collection {
        return $users->filter(fn (mixed $user) => $user->accountEnabled);
    },
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'image' => 'photo',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'mobile_phone' => 'mobilePhone',
        'address' => 'streetAddress',
        'phone' => fn (mixed $user) => Arr::first($user->businessPhones),
        'link_teams' => fn (mixed $user) => "https://teams.microsoft.com/l/chat/0/0?users=$user->userPrincipalName",
        'functions' => fn (mixed $user) => reference('functions')->identifiedBy('code')->from($user->jobTitle)->get(),
        'departments' => fn (mixed $user) => reference('departments')->identifiedBy('code')->from($user->department)->get(),
        'buildings' => fn (mixed $user) => reference('buildings')->identifiedBy('code')->from($user->officeLocation)->get(),
        'cities' => fn (mixed $user) => reference('cities')->identifiedBy('code')->from($user->city)->get(),
        'postal_code' => fn (mixed $user) => $user->extension_b4780ecd36a04661a22b1bd2dffe1bad_postalCode ?? $user->postalCode,
        'internal_phone' => 'extension_b4780ecd36a04661a22b1bd2dffe1bad_homePhone',
        'azure_groups' => fn (mixed $user) => collect($user->memberOf)
            ->pluck('id')
            ->map(fn (string $uuid) => reference('azure_groups')->identifiedBy('external_id')->from($uuid)->withoutCreation()->get())
            ->flatten()
            ->filter()
            ->unique()
            ->values()
            ->all(),
        'manager' => fn (mixed $user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->get(),
        'status' => fn () => true,
        'is_maintenance' => fn () => false,
    ],
    'custom_attributes' => [
        'manager' => 'mail',
        'homePhone' => 'value',
        'memberOf' => 'value',
    ],
    'internal_groups' => [
        'a22d069f-6d04-4963-b938-2d0f84e9835e' => 'App_EXTRANET_Administateurs',
        '5af23957-ac0f-4c46-a72b-f8557fc60608' => 'App_EXTRANET_Assistantes',
        '5340b7b8-ad79-4794-94f9-6b4daa4c4047' => 'App_EXTRANET_Utilisateurs',
        'e01150c3-b24b-484a-817f-4a87d17266fa' => 'App_EXTRANET_Managers',
        '6d093447-a999-4cf3-92c6-2980e0a3c3fb' => 'App_EXTRANET_Contributeurs',
    ]
];
