<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\AzureGroups;
use Inside\Host\Bridge\BridgeContent;

final class CreateAzureGroupsContents extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');

        $groups = collect([
            '49387a6c-8b76-4233-baf6-bc5b0772c18f' => 'App_EXTRANET_Invites',
            '5340b7b8-ad79-4794-94f9-6b4daa4c4047' => 'App_EXTRANET_Utilisateurs',
            'a22d069f-6d04-4963-b938-2d0f84e9835e' => 'App_EXTRANET_Administateurs',
            'c494c628-008b-4d8a-acef-c1f51e72a8d8' => 'App_EXTRANET_Reglementation',
            'e01150c3-b24b-484a-817f-4a87d17266fa' => 'App_EXTRANET_Managers',
        ]);

        $bridge = new BridgeContent();
        $groups->each(function (string $title, string $externalId) use ($bridge) {
            $data = [
                'title' => $title,
                'external_id' => $externalId,
            ];

            $existing = AzureGroups::where('external_id', $externalId)->first()?->uuid;

            if ($existing !== null) {
                $data['uuid'] = $existing;
                return $bridge->contentUpdate('azure_groups', $data, true);
            }

            return $bridge->contentInsert('azure_groups', $data, true, true);
        });
    }
}
