<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateUsersFunctionsAndDepartmentsFields extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'function');
        $this->getBridge()?->contentTypeDeleteField('user', 'user', 'department');

        $this->migrateContent('functions');
        $this->migrateContent('departments');
        $this->migrateContent('users');
        $this->finishUp();
    }
}
