<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

final class InitializeContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('cities');
        $this->migrateContent('buildings');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('flash_news');
        $this->migrateContent('blocks');
        $this->migrateContent('tabs_spaces_categories');
        $this->migrateContent('tabs_spaces');
        $this->migrateContent('tabs');
        $this->migrateContent('tabs_pages');
        $this->migrateContent('users');

        ContentBlueprints::generateContent('faq_categories');
        ContentBlueprints::generateContent('faq_questions');

        $this->finishUp();
    }
}
