import SpacePage from '../pages/spaces/SpacePage'
import SpacePagesPage from '../pages/spaces/SpacePagesPage'

import { fetchSpace, fetchSpaceMinimal } from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpace)
  },
  {
    name: 'SpacePagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpaceMinimal)
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
