export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacePagesPage',
      params: { slug: data.pages_categories.spaces.slug[0] },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacePagesPage',
      params: { slug: data.pages_categories.spaces.slug[0] }
    })
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePagesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePagesPage',
      params: { slug: data.spaces.slug[0] }
    })
  },
  poles: {
    add: () => ({
      name: 'DirectoryPage'
    })
  },
  locations: {
    add: () => ({
      name: 'DirectoryPage'
    })
  }
}
