export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      },
      {
        type: 'outlook',
        label: 'Outlook'
      },
      {
        type: 'office',
        label: 'Office'
      }
    ]
  },
  'inside-news': {
    bookmarkEnabled: false
  },
  'inside-events': {
    bookmarkEnabled: false,
    calendarImportEnabled: true
  },
  'inside-newcomers': {
    extraFields: [
      {
        field: 'function',
        class: 'function',
        data: data => data.function
      },
      { field: 'phone', class: 'phone', data: data => data.phone }
    ]
  },
  'inside-users': {
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  }
}
