import { http } from '@inside-library/helpers/Http'
import { newsFields, userFields } from '../../constants'

export const fetchSpaceMinimal = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: ['uuid', 'title', 'banner', 'introduction'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'introduction',
        'banner',
        'slug',
        'content_type',
        'admin',
        {
          users: {
            fields: userFields,
            filters: { sort: 'lastname:asc' }
          }
        },
        {
          tools: [
            'uuid',
            'title',
            'image',
            'icon',
            'has_section',
            'tools_link',
            'content_type',
            'admin',
            'published_at'
          ]
        },
        { structures: ['uuid', 'title', 'image', 'content_type'] },
        {
          documents: [
            'uuid',
            'title',
            'file',
            'has_section',
            'admin',
            'content_type',
            'published_at'
          ]
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: newsFields,
                  filters: {
                    reverse: true,
                    limit: 4,
                    'published_at:lte': 'now()'
                  }
                }
              }
            ],
            filters: {
              'published_at:lte': 'now()'
            }
          }
        },
        { pages_categories: { fields: ['count'], filters: { reverse: true } } }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
