<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class CreateProjectContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile');

        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('poles');
        $this->migrateContent('locations');
        $this->migrateContent('custom');
        $this->migrateContent('users');
        $this->migrateContent('pages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('flash_news');
        $this->migrateContent('spaces');
        $this->migrateContent('pages_categories');
        $this->migrateContent('spaces_pages');

        $this->finishUp();
    }
}
