import SpacesListingPage from '../pages/spaces/SpacesListingPage'
import SpacesPage from '../pages/spaces/SpacesPage'
import { fetchSpacesListing, fetchSpacesPage } from '../components/spaces'

import DocumentsListingPage from '../pages/documents/DocumentsListingPage'
import { fetchDocuments } from '../pages/documents'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/directory/DirectoryPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'SpacesListingPage',
    path: '/services',
    component: withFetch(SpacesListingPage)(fetchSpacesListing)
  },
  {
    name: 'SpacesPage',
    path: '/service/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'TeamsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'DocumentsListingPage',
    path: '/mon-abonnement',
    component: withFetch(DocumentsListingPage, { size: 'xxl' })(fetchDocuments)
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
