import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'SpacesListingPage'
    })
  },
  categoriesSpaces: {
    fields: ['uuid', { spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] },
      query: { tab: data.uuid }
    }),
    delete: () => ({
      routeAs: 'add'
    }),
    globalSearch: async ({ data }) => {
      const { data: space } = await http.get('content/categories_spaces', {
        fields: ['uuid', { spaces: ['uuid', 'slug'] }],
        filters: { 'uuid:eq': data?.uuid }
      })

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: space?.[0]?.spaces?.slug?.[0]
          },
          query: { tab: data?.uuid }
        }
      }
    }
  },
  pagesSpaces: {
    fields: [{ categories_spaces: ['uuid', { spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.categories_spaces.spaces.slug[0]
      },
      query: { tab: data.categories_spaces.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.categories_spaces.spaces.slug[0]
      }
    }),
    globalSearch: async ({ data }) => {
      const { data: spacesCategories } = await http.get(
        'content/pages_spaces',
        {
          fields: [
            'uuid',
            {
              categories_spaces: ['uuid', 'title', { spaces: ['uuid', 'slug'] }]
            }
          ],
          filters: { 'uuid:eq': data?.uuid }
        }
      )

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: spacesCategories?.[0]?.categories_spaces?.spaces?.slug?.[0]
          },
          query: { tab: spacesCategories?.[0]?.categories_spaces?.uuid }
        }
      }
    }
  }
}
