import { http } from '@inside-library/helpers/Http'
import { storage } from '@inside-library/helpers/Storage'

export const fetchDocuments = async () => {
  try {
    const { data } = await http.get('content/subscriber_contents', {
      fields: [
        'uuid',
        'slug',
        'title',
        'document',
        'published_at',
        {
          user: [
            'uuid',
            'firstname',
            'lastname',
            'image',
            { cities: ['title'] }
          ]
        }
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        user: { 'uuid:eq': storage.get('current-user').uuid }
      }
    })

    return data
  } catch (error) {
    throw new Error(error)
  }
}
