import { http } from '@inside-library/helpers/Http'

export const fetchSpacesListing = async () => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: ['uuid', 'slug', 'admin', 'content_type', 'title', 'image'],
      filters: {
        'status:eq': 1,
        sort: 'weight:asc'
      }
    })

    return data
  } catch (error) {
    throw new Error(error)
  }
}

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'admin',
        'content_type'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
