import { http } from '@inside-library/helpers/Http'

export const fetchUserInfos = async () => {
  try {
    const { data } = await http.get('content/users', {
      fields: [
        'uuid',
        'title',
        'slug',
        'published_at',
        'content_type',
        'place',
        'date',
        'end_date'
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': this.getUserInfos.uuid,
        limit: 1
      }
    })

    return data
  } catch (error) {
    throw new Error(error)
  }
}
