<?php

namespace Inside\AGRE\Providers;

use Inside\AGRE\Observers\SubscriberContentsObserver;
use Inside\Content\Models\Contents\SubscriberContents;
use Inside\Providers\ServiceProvider as BaseServiceProvider;

/**
 * AGRE Service provider.
 *
 * @category Class
 * @package  Inside\\AGRE\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        if (class_exists(SubscriberContents::class)) {
            SubscriberContents::observe(SubscriberContentsObserver::class);
        }
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__.'/../../config/xlsx.php', 'xlsx');
        $this->mergeConfigFrom(__DIR__.'/../../config/csv.php', 'csv');
        $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        $this->mergeConfigTo(__DIR__.'/../../config/statistics.php', 'statistics');
    }
}
