<?php

namespace Inside\AGRE\Actions;

use Illuminate\Support\Facades\Mail;
use Inside\AGRE\Mails\SubscriberContentPublished;
use Inside\AGRE\Mails\SubscriberContentUpdated;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\SubscriberContents;
use Inside\Logging\Logger;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class NotifyUserOfSubscriberContent extends BaseNotificationListener
{
    /**
     * Handle the User "created" event.
     *
     * @param  SubscriberContents  $subscriberContents
     * @return void
     */
    public function __invoke(SubscriberContents $subscriberContents, string $action): void
    {
        $notificationType = NotificationType::query()
            ->where('model', SubscriberContents::class)
            ->where('action', $action)
            ->where('via', 'web')
            ->first();

        if (! $notificationType instanceof  NotificationType) {
            return;
        }

        /** @var User $user */
        $user = User::find($subscriberContents->user->first()->uuid);

        $this->notify(
            $notificationType,
            $user,
            $subscriberContents,
            ['url' => 'mon-abonnement']
        );

        match ($action) {
            'create' => Mail::to($user->email)->send(new SubscriberContentPublished()),
            'update' => Mail::to($user->email)->send(new SubscriberContentUpdated()),
            default => null
        };
    }
}
