@php
    use Inside\Settings\Models\Setting;
@endphp
@component('mail::layout')
    {{-- Header --}}
    @slot('header')
        @component('mail::header', ['url' => config('app.url')])
            {{ config('app.name') }}
        @endcomponent
    @endslot

    {{-- Body --}}
    {{ $slot }}

    {{-- Footer --}}
    @slot('footer')
        @component('mail::footer')
            {{ __('newsletter.unsubscribe.warning') }} <br />
            © {{ date('Y') }} {{ Setting::where('key', 'meta_title')->first()?->value ?? config('app.name') }}. Tous droits réservés.<br/>
            <i>Powered by <a href="https://www.intranet-inside.com" style="text-decoration: none; color: #FF7C49;">Intranet Inside</a></i>
        @endcomponent
    @endslot
@endcomponent
