<?php

use Drupal\Core\Entity\EntityStorageException;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Exceptions\ColumnAlreadyExistsException;

class AddBusinessSoftwareFieldToUser extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     * @throws EntityStorageException|ColumnAlreadyExistsException
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('users', 'business_software', [
            'name' => 'business_software',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 25,
            'title' => [
                'fr' => 'Logiciel métier',
            ],
            'description' => [
                'fr' => 'Logiciel métier de l\'agence',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 20,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'default' => "",
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     * @throws EntityStorageException
     */
    public function down(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('users', 'user', 'business_software');
    }
}
